/*
 * Decompiled with CFR 0.152.
 */
package com.sntl.lspmgmtclean;

import com.sntl.lspmgmtclean.NativeLibraryInterface;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;

public class LsPmgmtAPI {
    private static volatile LsPmgmtAPI instance;
    private static NativeLibraryInterface nativeLibInstance;
    private static Object mutex;
    private boolean arch_32bit = System.getProperties().getProperty("os.arch").equals("x86") || System.getProperties().getProperty("os.arch").equals("i386") || System.getProperty("sun.arch.data.model") != null && System.getProperty("sun.arch.data.model").indexOf("32") >= 0;
    private static boolean HPUX;
    private static boolean AIX;
    String LibraryName = "";
    String LibraryNameProperty = "";
    String propertyKey = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeLibraryInterface getInstance() {
        LsPmgmtAPI result = instance;
        if (result == null) {
            Object object = mutex;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = new LsPmgmtAPI(0);
                }
            }
        }
        return nativeLibInstance;
    }

    public LsPmgmtAPI() {
        LsPmgmtAPI.getInstance();
    }

    private LsPmgmtAPI(int dummy) {
        try {
            if (Platform.isWindows()) {
                this.LibraryName = this.arch_32bit ? "./lspmgmtclean32" : "./lspmgmtclean64";
                this.propertyKey = "sntl.pmgmt.win.library.name";
            } else if (Platform.isLinux()) {
                this.LibraryName = this.arch_32bit ? "./liblspmgmtclean.so" : "./liblspmgmtclean64.so";
                this.propertyKey = "sntl.pmgmt.unix.library.name";
            } else if (Platform.isSolaris()) {
                this.LibraryName = this.arch_32bit ? "./liblspmgmtclean.so" : "./liblspmgmtclean64.so";
                this.propertyKey = "sntl.pmgmt.solaris.library.name";
            } else if (Platform.isMac()) {
                this.LibraryName = this.arch_32bit ? "./liblspmgmtclean.dylib" : "./liblspmgmtclean64.dylib";
                this.propertyKey = "sntl.pmgmt.mac.library.name";
            } else if (Platform.isAndroid()) {
                boolean android_architecture = System.getProperties().getProperty("os.arch").equals("aarch64");
                this.LibraryName = android_architecture ? "lspmgmtclean64" : "lspmgmtclean";
                this.propertyKey = "sntl.pmgmt.android.library.name";
            } else if (HPUX || AIX) {
                String platform = System.getProperty("os.name") + "-" + System.getProperty("os.arch");
                String Add_platforms = "AdditionalPlatforms/" + platform;
                System.setProperty("jna.boot.library.path", Add_platforms);
                if (HPUX) {
                    boolean IA64N_architecture = System.getProperties().getProperty("os.arch").equals("IA64N");
                    this.LibraryName = IA64N_architecture ? "./liblspmgmtclean.sl" : "./liblspmgmtclean64.sl";
                    this.propertyKey = "sntl.pmgmt.hpux.library.name";
                } else if (AIX) {
                    boolean ppc_architecture = System.getProperties().getProperty("os.arch").equals("ppc");
                    this.LibraryName = ppc_architecture ? "./liblspmgmtclean.so" : "./liblspmgmtclean64.so";
                    this.propertyKey = "sntl.pmgmt.aix.library.name";
                }
            }
            File file = new File(this.LibraryName);
            if (Platform.isAndroid()) {
                this.LibraryNameProperty = System.getProperty(this.propertyKey, this.LibraryName);
            } else {
                String path = file.getCanonicalPath();
                this.LibraryNameProperty = System.getProperty(this.propertyKey, path);
            }
            nativeLibInstance = (NativeLibraryInterface)Native.loadLibrary((String)this.LibraryNameProperty, NativeLibraryInterface.class);
            System.setProperty("jna.encoding", "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cleanup() {
        LsPmgmtAPI.getInstance().sntl_persistence_cleanup();
    }

    public static long getPointerNativeValue(PointerByReference ptrRef) {
        String prefix;
        String nativeValue = ptrRef.getValue().toString();
        if (nativeValue.indexOf(prefix = "native@0x") != 0) {
            return 0L;
        }
        String value = nativeValue.substring(prefix.length());
        return Long.parseLong(value, 16);
    }

    static {
        mutex = new Object();
        HPUX = System.getProperty("os.name").toUpperCase().equals("HP-UX");
        AIX = System.getProperty("os.name").toUpperCase().equals("AIX");
    }
}

