/*
 * Decompiled with CFR 0.152.
 */
package com.sntl.lspmgmtclean;

import com.sntl.lspmgmtclean.LsPmgmtAPI;
import com.sntl.lspmgmtclean.LsPmgmtAttribute;
import com.sntl.lspmgmtclean.LsPmgmtException;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;

public class LsPmgmtContext {
    private long ptrNativeValue;

    protected Pointer getPointer() {
        return new Pointer(this.ptrNativeValue);
    }

    public LsPmgmtContext(int device) throws LsPmgmtException, UnsupportedEncodingException {
        this(device, null);
    }

    public LsPmgmtContext(int device, LsPmgmtAttribute attribute) throws LsPmgmtException, UnsupportedEncodingException {
        PointerByReference ptrPmgmtContextRef = new PointerByReference();
        Pointer ptrAttribute = attribute != null ? attribute.getPointer() : new Pointer(0L);
        int status = LsPmgmtAPI.getInstance().sntl_persistence_context_new(device, ptrAttribute, ptrPmgmtContextRef);
        if (status != 0) {
            throw new LsPmgmtException(status, "sntl_persistence_context_new failed");
        }
        this.ptrNativeValue = LsPmgmtAPI.getPointerNativeValue(ptrPmgmtContextRef);
    }

    public int repair(String scope) throws LsPmgmtException, UnsupportedEncodingException {
        int status = LsPmgmtAPI.getInstance().sntl_persistence_repair(this.getPointer(), scope);
        if (status != 0) {
            throw new LsPmgmtException(status, "sntl_persistence_repair failed");
        }
        return status;
    }

    public int reset(String scope) throws LsPmgmtException, UnsupportedEncodingException {
        int status = LsPmgmtAPI.getInstance().sntl_persistence_reset(this.getPointer(), scope);
        if (status != 0) {
            throw new LsPmgmtException(status, "sntl_persistence_reset failed");
        }
        return status;
    }

    public String getInfo(String scope, String query) throws LsPmgmtException, UnsupportedEncodingException {
        PointerByReference ptrInfoRef = new PointerByReference();
        int status = LsPmgmtAPI.getInstance().sntl_persistence_get_info(this.getPointer(), scope, query, ptrInfoRef);
        if (status != 0) {
            throw new LsPmgmtException(status, "sntl_persistence_get_info failed");
        }
        Pointer ptrInfo = ptrInfoRef.getValue();
        if (ptrInfo != null) {
            String info = new String(ptrInfo.getString(0L));
            LsPmgmtAPI.getInstance().sntl_persistence_free(ptrInfo);
            return info;
        }
        return "";
    }

    public void dispose() throws LsPmgmtException {
        if (this.ptrNativeValue != 0L) {
            LsPmgmtAPI.getInstance().sntl_persistence_context_delete(this.getPointer());
            this.ptrNativeValue = 0L;
        }
    }

    @Deprecated
    protected void finalize() {
        try {
            this.dispose();
        }
        catch (LsPmgmtException lsPmgmtException) {
            // empty catch block
        }
    }

    static {
        LsPmgmtAPI.getInstance();
        LsPmgmtAPI.getInstance();
    }
}

