/*
 * Decompiled with CFR 0.152.
 */
package com.velasolaris.polysun.licensing.rms.repair;

import com.velasolaris.polysun.licensing.rms.repair.RmsNativeLibraryLoader;
import com.velasolaris.polysun.licensing.rms.repair.RmsPersistenceRepairer;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class App {
    private static final Logger logger = Logger.getLogger(App.class.getName());

    public static void main(String[] args) {
        try {
            new RmsNativeLibraryLoader().loadRmsNativeLibraries();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to load RMS C libraries.", t);
            System.exit(-1);
        }
        try {
            new RmsPersistenceRepairer(logger).repairStandalonePersistenceData();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to repair Sentinel RMS persistence data.", t);
            System.exit(-1);
        }
        logger.info("RMS license persistence data repaired successuflly.");
    }

    static {
        boolean hasConsoleHandler = Arrays.stream(logger.getHandlers()).anyMatch(handler -> handler instanceof ConsoleHandler);
        if (!hasConsoleHandler) {
            ConsoleHandler handler2 = new ConsoleHandler();
            handler2.setFormatter(new SimpleFormatter());
            logger.addHandler(handler2);
        }
    }
}

