/*
 * Decompiled with CFR 0.152.
 */
package com.velasolaris.polysun.licensing.rms.repair;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class RmsNativeLibraryLoader {
    public void loadRmsNativeLibraries() throws IOException {
        boolean arch_32bit = System.getProperties().getProperty("os.arch").equals("x86") || System.getProperties().getProperty("os.arch").equals("i386") || System.getProperty("sun.arch.data.model") != null && System.getProperty("sun.arch.data.model").indexOf("32") >= 0;
        String libraryName = null;
        String propertyKey = null;
        if (Platform.isWindows()) {
            libraryName = arch_32bit ? "lspmgmtclean32.dll" : "lspmgmtclean64.dll";
            propertyKey = "sntl.pmgmt.win.library.name";
        } else if (Platform.isLinux()) {
            libraryName = arch_32bit ? "liblspmgmtclean.so" : "liblspmgmtclean64.so";
            propertyKey = "sntl.pmgmt.unix.library.name";
        } else if (Platform.isMac()) {
            libraryName = arch_32bit ? "liblspmgmtclean.dylib" : "liblspmgmtclean64.dylib";
            propertyKey = "sntl.pmgmt.mac.library.name";
        } else {
            throw new RuntimeException("The current platform is not supported: " + System.getProperty("os.name"));
        }
        InputStream libraryResourceStream = this.getClass().getClassLoader().getResourceAsStream(libraryName);
        if (libraryResourceStream == null) {
            throw new RuntimeException("Could not load the RMS persistence cleaning library: " + libraryName);
        }
        File tempDir = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]).toFile();
        File tempLibrary = new File(tempDir, libraryName);
        Files.copy(libraryResourceStream, tempLibrary.toPath(), new CopyOption[0]);
        System.setProperty(propertyKey, tempLibrary.getAbsolutePath());
    }
}

